# NewsML-G2 Documentation

The latest version of NewsML-G2 is 2.29, approved by the IPTC Standards
Committee in May 2020.

## NewsML-G2 Quick Start guides

We have created a set of Quick Start guides to help developers understand the
key concepts behind NewsML-G2.

There are currently five Quick Start guides:

* [NewsML-G2 Quick Start: Basics](https://www.iptc.org/std-dev/NewsML-G2/documentation/quickstart-basics.html)
* [NewsML-G2 Quick Start: Text](https://www.iptc.org/std-dev/NewsML-G2/documentation/quickstart-text.html)
* [NewsML-G2 Quick Start: Pictures](https://www.iptc.org/std-dev/NewsML-G2/documentation/quickstart-pictures.html)
* [NewsML-G2 Quick Start: Video](https://www.iptc.org/std-dev/NewsML-G2/documentation/quickstart-video.html)
* [NewsML-G2 Quick Start: Packages](https://www.iptc.org/std-dev/NewsML-G2/documentation/quickstart-packages.html)

After reading the Quick Start guides, we recommend reading the rest of
the
[NewsML-G2 Guidelines](https://www.iptc.org/std/NewsML-G2/guidelines),
and consulting the full
[NewsML-G2 Specification](https://www.iptc.org/std/NewsML-G2/specification/)
and
[XML Schema documentation](https://www.iptc.org/std/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/)
for finer details.

## NewsML-G2 Specification document

The latest version of the NewsML-G2 Specification in HTML is 2.28.

This is available at
[https://www.iptc.org/std/NewsML-G2/2.28/specification/NewsML-G2-2.28-specification.html](https://www.iptc.org/std/NewsML-G2/2.28/specification/NewsML-G2-2.28-specification.html)

The latest version is always hosted at
[https://www.iptc.org/std/NewsML-G2/specification/](https://www.iptc.org/std/NewsML-G2/specification/)

## NewsML-G2 Guidelines document

The latest version of the NewsML-G2 Guidelines is published at
[https://www.iptc.org/std/NewsML-G2/guidelines](https://www.iptc.org/std/NewsML-G2/guidelines)

### Guidelines for older versions of NewsML-G2

Guidelines for older versions of NewsML-G2 (up to 2.25) were maintained in PDF format.
The last version to be published in PDF was the 
[NewsML 2.25 guidelines in PDF](https://www.iptc.org/std/NewsML-G2/2.25/documentation/IPTC-NewsML-G2-Implementation_Guide_9.0.2.pdf).

## XML Schema documentation

[NewsML-G2 XML Schema docs](https://www.iptc.org/std/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/)
generated directly from the NewsML-G2 XML Schema are available in the
specification folder:
[https://www.iptc.org/std/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/](https://www.iptc.org/std/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/)

The XML Schema docs are separated into documentation for each of the major components of NewsML-G2:

* [CatalogItem](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-CatalogItem-Power.html)
* [ConceptItem](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-ConceptItem-Power.html)
* [Framework](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-Framework-Power.html)
* [KnowledgeItem](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-KnowledgeItem-Power.html)
* [NewsItem](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-NewsItem-Power.html)
* [NewsMessage](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-NewsMessage-Power.html)
* [PackageItem](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-PackageItem-Power.html)
* [PlanningItem](https://www.iptc.org/std-dev/NewsML-G2/2.29/specification/XML-Schema-Doc-Power/NewsML-G2_2.29-spec-PlanningItem-Power.html)

## NewsML-G2 Structure Matrix

A matrix showing which attributes apply to which elements is maintained as an Excel spreadsheet:
[https://www.iptc.org/std/NewsML-G2/2.26/documentation/NewsML-G2_2.26-structMatrix_1.xls](https://www.iptc.org/std/NewsML-G2/2.26/documentation/NewsML-G2_2.26-structMatrix_1.xls)

## Further information and questions

For any questions, comments or suggestions, please join the public NewsML-G2
forum at
[https://groups.io/g/iptc-newsml-g2](https://groups.io/g/iptc-newsml-g2).
